//********************************************************************************
//								     Include
//********************************************************************************
#include "MDSFxx_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"

#define BUSY 	0x08
#define START 	0x01

//********************************************************************************
//								   ADC INIT
//********************************************************************************
void Adc_Init (void){
	ADCCONT = ADCCONT_REGS;
	ADCSTR = ADCSTR_REGS | OPA_GAIN_REGS;
	ADCDLY = 0x30;
	IA_AD_OFFSET(512);		//512 = 2.5V; 1023 = 5V
	IB_AD_OFFSET(512);
}
//********************************************************************************
//								  ADC Channel
//********************************************************************************
//#if ((POWER_CONTROL == 1) || (POWER_LIMIT == 1) || (VSP_TRI == 1) || (Vbus_Protect == 1) || (Temperture_Protect == 1))
signed int Adc_Channel (unsigned char Channel){
	int16 Temp;
	ADCCONT = (ADCCONT | Channel);
	ADCSTR = (ADCSTR | START);
	while((ADCSTR & BUSY) == BUSY){}; //Check ADC Busy end
	Temp = ADCD1;
	Temp = Temp << 8;
	Temp |= ADCD2;
	ADCCONT = (ADCCONT & 0xF8);
	return Temp;
}
//#endif
//********************************************************************************
//							  Correction Current
//********************************************************************************
// idata	signed int	ia_values;
// idata	signed int	ib_values;

xdata	signed int OPA_Offset;
xdata	signed int OPA_OffsetTemp;
xdata	signed long OPA_Offset_C = 0;
xdata	unsigned int OffsetCount;

void Correction_Current_AD_offset(void){
	signed long Tmp = Ibus_avg;
	OPA_OffsetTemp = DATA_FILTER(Tmp, OPA_Offset_C, OPA_OffsetTemp, signed short, 8);
	OffsetCount++;
	if(OffsetCount >= 2000)
	{
		OffsetCount = 0;
		OPA_Offset = OPA_OffsetTemp;
		OPA_OffsetTemp = 0;
		OPA_Offset_C = 0;
		FLAG.Current_offset = 1;
	}
}
